import {NgModule} from '@angular/core';
import {BraintreePaymentAdapter} from './adapters/braintree-payment.adapter';
import {
  BraintreeCheckoutAdapter,
  PaymentAdapter,
  PaymentDetailsAdapter,
  PaypalAbstractPaymentAdapter,
  ConnectAdapter, UserAdapter, LoginAdapter
} from '../braintree-checkout/connectors';
import {BraintreePaymentDetailsAdapter} from './adapters/braintree-payment-details.adapter';
import {UserPaymentAdapter} from '@spartacus/core';
import {BraintreeUserPaymentAdapter} from './adapters/braintree-user-payment.adapter';
import {DefaultBraintreeCheckoutAdapter} from './adapters/default-braintree-checkout.adapter';
import {PaypalPaymentAdapter, PaypalConnectAdapter, BraintreeUserAdapter, BraintreeLoginAdapter} from "./adapters";


@NgModule({
  declarations: [],
  providers: [
    {
      provide: PaymentAdapter,
      useClass: BraintreePaymentAdapter,
    },
    {
      provide: PaymentDetailsAdapter,
      useClass: BraintreePaymentDetailsAdapter,
    },
    {
      provide: UserPaymentAdapter,
      useClass: BraintreeUserPaymentAdapter,
    },
    {
      provide: BraintreeCheckoutAdapter,
      useClass: DefaultBraintreeCheckoutAdapter,
    },
    {
      provide: PaypalAbstractPaymentAdapter,
      useClass: PaypalPaymentAdapter,
    },
    {
      provide: ConnectAdapter,
      useClass:PaypalConnectAdapter
    },
    {
      provide: UserAdapter,
      useClass: BraintreeUserAdapter,
    },
    {
      provide: LoginAdapter,
      useClass: BraintreeLoginAdapter,
    }
    ],
})
export class BraintreeOccModule { }
