import {Injectable} from "@angular/core";
import {PaypalAbstractPaymentAdapter} from "../../braintree-checkout/connectors/paypal-payment.adapter";
import {ConverterService, OccEndpointsService} from '@spartacus/core';
import {HttpClient, HttpParams} from '@angular/common/http';
import {CHECKOUT_DATA_NORMALIZER, CheckoutData} from "../../braintree-checkout";
import {Observable} from "rxjs";

@Injectable()
export class PaypalPaymentAdapter implements PaypalAbstractPaymentAdapter
{
    constructor(
        protected http: HttpClient,
        protected occEndpoints: OccEndpointsService,
        protected converter: ConverterService
    ) {}

    protected getEndpoint(userId): string{
        return this.occEndpoints.buildUrl('users/${userId}', {
            urlParams: { userId },
        }) + '/connect/paypal';
    }

    loadCheckoutData(pageType: string, userId: string): Observable<CheckoutData> {
        const params = new HttpParams()
            .set('pageType', pageType);

        return this.http.get( this.getEndpoint(userId), { params })
            .pipe(this.converter.pipeable(CHECKOUT_DATA_NORMALIZER));
    }

}