import {Injectable} from "@angular/core";
import {HttpClient, HttpHeaders, HttpParams} from "@angular/common/http";
import {ConverterService, OccEndpointsService} from "@spartacus/core";
import {SetUpPasswordFormData, UserAdapter} from "../../braintree-checkout";
import {Observable} from "rxjs";
import {BRAINTREE_USER_SET_UP_PASSWORD_FORM_DATA_NORMALIZER} from "../../braintree-checkout/converters";

@Injectable()
export class BraintreeUserAdapter implements UserAdapter {
    constructor(
        protected http: HttpClient,
        protected occEndpoints: OccEndpointsService,
        protected converter: ConverterService
    ) {}

    protected getEndpoint(userId): string{
        return this.occEndpoints.buildUrl('users/${userId}', {
            urlParams: { userId }
        });
    }

    getSetUpPasswordFormData(
        userId: string
    ): Observable<SetUpPasswordFormData>{
        const url = `${this.getEndpoint(userId)}/getSetUpPasswordFormData`;
        return this.http.get(url,{}).pipe(this.converter.pipeable(BRAINTREE_USER_SET_UP_PASSWORD_FORM_DATA_NORMALIZER));
    }

    setUpPasswordForPayPalCustomer(
        newPassword: string,
        userId: string
    ): Observable<any> {
        const headers = new HttpHeaders({
            'Content-Type': 'application/json'
        });
        const url = `${this.getEndpoint(userId)}/setPassword`;
        const params: HttpParams = new HttpParams().set('newPassword', newPassword);
        return this.http.post(url, {}, {headers, params});

    }

}