import {Injectable} from "@angular/core";
import {HttpClient, HttpHeaders, HttpParams} from "@angular/common/http";
import {ConverterService, OccEndpointsService} from "@spartacus/core";
import {ExpireStatusMessageData} from "../../braintree-checkout";
import {Observable} from "rxjs";
import {
    BRAINTREE_EXPIRE_STATUS_MESSAGE_DATA_NORMALIZER,
} from "../../braintree-checkout/converters";
import {LoginAdapter} from "../../braintree-checkout/connectors/login.adapter";

@Injectable()
export class BraintreeLoginAdapter implements LoginAdapter {
    constructor(
        protected http: HttpClient,
        protected occEndpoints: OccEndpointsService,
        protected converter: ConverterService
    ) {}

    protected getEndpoint(): string{
        return this.occEndpoints.buildUrl('braintreeLogin');
    }

    getExpireStatusMessageData(): Observable<ExpireStatusMessageData>{
        const url = `${this.getEndpoint()}/getExpireCardsStatus`;
        return this.http.get(url,{}).pipe(this.converter.pipeable(BRAINTREE_EXPIRE_STATUS_MESSAGE_DATA_NORMALIZER));
    }

}
