import {Injectable} from "@angular/core";
import {BraintreePaymentDetailsService} from '../../facade/braintree-payment-details.service';
import {Address} from "@spartacus/core";
import {UpdateCreditCardBillingAddressRequest} from "../../models";
import {Observable} from "rxjs";

@Injectable({
  providedIn: 'root'
})

export class BraintreeCreditCardService {

  constructor(
      protected braintreePaymentDetailsService: BraintreePaymentDetailsService
  ) {
  }

  updateCreditCardBillingAddress(address: Address, paymentId: string): Observable<any> {
    const updateCreditCardBillingAddressRequest: UpdateCreditCardBillingAddressRequest = {
      billingAddress: address,
      paymentMethodId : paymentId
    };
   return this.braintreePaymentDetailsService.updateCreditCardBillingAddress(updateCreditCardBillingAddressRequest);
  }
}
