import { TranslationService } from '@spartacus/core';
import { Injectable } from '@angular/core';
import { Observable, of } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class BraintreePaymentMethodsErrorHandlerService {


  constructor(
    protected translation: TranslationService
  ) {
  }

  private braintreeErrorMessagesByCode = {
   client_request_timeout: this.translation.translate('error.client_request_timeout'),
    client_gateway_network: this.translation.translate('error.client_gateway_network'),
    client_request_error: this.translation.translate('error.client_request_error'),
    client_missing_gateway_configuration: this.translation.translate('error.client_missing_gateway_configuration'),
    paypal_account_tokenization_failed: this.translation.translate('error.paypal_account_tokenization_failed'),
    paypal_invalid_payment_option: this.translation.translate('error.paypal_invalid_payment_option'),
    paypal_flow_failed: this.translation.translate('error.paypal_flow_failed'),
    paypal_browser_not_supported: this.translation.translate('error.paypal_browser_not_supported'),
    paypal_flow_option_required: this.translation.translate('error.paypal_flow_option_required'),
  };

  getErrorMessage(errorCode): Observable<string> {
    const res = this.braintreeErrorMessagesByCode[errorCode];
    if (res !== undefined){
      return res;
    }
    return of(res);
  }

  getErrorMessageByDetailedMessage(detailedMessage: string): Observable<string> {
    if (detailedMessage.startsWith('Currency code')) {
      return this.translation.translate('error.lpm_invalid_currency');
    } else if (detailedMessage.startsWith('Country code')) {
      return this.translation.translate('error.lpm_invalid_county');
    } else {
      return this.translation.translate('error.lpm_payment_failed');
    }
  }

}
