import { Injectable } from '@angular/core';
import {
  ActiveCartService,
  OCC_USER_ID_ANONYMOUS,
  PaymentDetails, StateWithProcess,
  UserIdService
} from '@spartacus/core';
import {
  CheckoutActions,
  CheckoutPaymentConnector,
  StateWithCheckout,
} from '@spartacus/checkout/core';
import {Store} from '@ngrx/store';
import {Observable} from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class BraintreeCheckoutPaymentService {

  constructor(
    protected checkoutStore: Store<StateWithCheckout | StateWithProcess<void>>,
    protected activeCartService: ActiveCartService,
    protected userIdService: UserIdService,
    private checkoutPaymentConnector: CheckoutPaymentConnector,

  ) { }

  setPaymentDetailsMarkCheckout(paymentDetails: PaymentDetails): Observable<any> {
    if (this.actionAllowed()) {
      let userId;
      this.userIdService
        .getUserId()
        .subscribe((occUserId) => (userId = occUserId))
        .unsubscribe();

      let cartId;
      this.activeCartService
        .getActiveCartId()
        .subscribe((activeCartId) => (cartId = activeCartId))
        .unsubscribe();

      if (userId && cartId) {

       return  this.checkoutPaymentConnector
            .set(userId, cartId, paymentDetails.id);
      }
    }
  }

  setPaymentDetails(paymentDetails: PaymentDetails): void {
    if (this.actionAllowed()) {
      let userId;
      this.userIdService
        .getUserId()
        .subscribe((occUserId) => (userId = occUserId))
        .unsubscribe();

      let cartId;
      this.activeCartService
        .getActiveCartId()
        .subscribe((activeCartId) => (cartId = activeCartId))
        .unsubscribe();

      if (userId && cartId) {

        this.checkoutStore.dispatch(
          new CheckoutActions.SetPaymentDetails({
            userId,
            cartId,
            paymentDetails,
          })
        );
      }
    }
  }

  protected actionAllowed(): boolean {
    let userId;
    this.userIdService
      .getUserId()
      .subscribe((occUserId) => (userId = occUserId))
      .unsubscribe();
    return (
      (userId && userId !== OCC_USER_ID_ANONYMOUS) ||
      this.activeCartService.isGuestCart()
    );
  }
}
