import {Injectable} from "@angular/core";
import {CheckoutData} from "../models";
import {Observable} from "rxjs";
import {UserIdService} from "@spartacus/core";
import {PaypalPaymentDetailsConnector} from "../connectors/paypal-payment-details.connector";

@Injectable({
    providedIn: 'root'
})
export class PaypalPaymentDetailsService {

    constructor(
        protected userIdService: UserIdService,
        protected paymentConnector: PaypalPaymentDetailsConnector,
    ) {}

    public loadPaymentDetails(pageType: string): Observable<CheckoutData> {
        let userId;
        this.userIdService
            .getUserId()
            .subscribe((occUserId) => (userId = occUserId))
            .unsubscribe();
        return this.paymentConnector.loadPaymentDetails(pageType, userId);
    }
}