import {Injectable} from '@angular/core';
import {UserIdService} from '@spartacus/core';
import {Observable} from 'rxjs';
import {SetUpPasswordFormData} from '../models';
import {BraintreeUserConnector} from "../connectors/braintree-user.connector";

@Injectable({
    providedIn: 'root'
})
export class BraintreeUserService {

    constructor(
        protected userIdService: UserIdService,
        protected braintreeUserConnector: BraintreeUserConnector,
    ) {}

    public getSetUpPasswordFormData(): Observable<SetUpPasswordFormData> {
        let userId;
        this.userIdService
            .getUserId()
            .subscribe((occUserId) => (userId = occUserId))
            .unsubscribe();
        return this.braintreeUserConnector.getSetUpPasswordFormData(userId);
    }

    public setUpPasswordForPayPalCustomer(
        newPassword: string
    ): Observable<any> {
        let userId;
        this.userIdService
            .getUserId()
            .subscribe((occUserId) => (userId = occUserId))
            .unsubscribe();
        return this.braintreeUserConnector.setUpPasswordForPayPalCustomer(newPassword, userId);
    }
}