import {Injectable} from '@angular/core';
import {Observable} from 'rxjs';
import {ExpireStatusMessageData} from '../models';
import {BraintreeLoginConnector} from "../connectors/braintree-login.connector";
import {GlobalMessageService, GlobalMessageType} from '@spartacus/core';

@Injectable({
    providedIn: 'root'
})
export class BraintreeLoginService {

    message: Observable<string>;

    constructor(
        protected braintreeLoginConnector: BraintreeLoginConnector,
        protected globalMessage: GlobalMessageService,
    ) {}

    public showExpireStatusMessage(){
        this.getExpireStatusMessageData().subscribe(
            messageData => {
                if(messageData.expiredStatus == 'EXPIRED'){
                    this.globalMessage.add({key: 'paymentDetails.userHaveExpiredCardMessage'}, GlobalMessageType.MSG_TYPE_INFO, 10000);
                }
                if(messageData.expiredStatus == 'EXPIRE_SOON') {
                    this.globalMessage.add({key: 'paymentDetails.userHaveExpiredSoonCardMessage'}, GlobalMessageType.MSG_TYPE_INFO, 10000);
                }
            });
    }

    public getExpireStatusMessageData(
    ): Observable<ExpireStatusMessageData> {
        return this.braintreeLoginConnector.getExpireStatusMessageData();
    }
}
