import {Converter} from '@spartacus/core';
import {InjectionToken} from '@angular/core';
import {
  PayPalConnectB2BData,
  PayPalConnectB2BRegisterData,
  PayPalConnectData,
  PayPalConnectLoginData, SetUpPasswordFormData,
  AddingPaymentMethodAndAddressStatusData, ExpireStatusMessageData
} from '../models';


export const PAYPAL_CONNECT_DATA_NORMALIZER = new InjectionToken<
    Converter<any, PayPalConnectData>
    >('PayPalConnectDataNormalizer');

export const  PAYPAL_CONNECT_B2B_REGISTER_DATA_SERIALIZER = new InjectionToken<
    Converter<PayPalConnectB2BRegisterData, any>
    >('PayPalConnectB2BRegisterDataSerializer');

export const PAYPAL_BOOLEAN_NORMALIZER = new InjectionToken<
    Converter<any, boolean>
    >('PayPalBooleanNormalizer');

export const PAYPAL_CONNECT_B2B_DATA_NORMALIZER = new InjectionToken<
    Converter<any, PayPalConnectB2BData>
    >('PayPalConnectB2BDataNormalizer');

export const PAYPAL_CONNECT_LOGIN_DATA_NORMALIZER = new InjectionToken<
    Converter<any, PayPalConnectLoginData>
    >('PayPalConnectLoginDataNormalizer');

export const PAYPAL_STRING_NORMALIZER = new InjectionToken<
    Converter<any, string>
    >('PayPalStringNormalizer');

export const BRAINTREE_USER_SET_UP_PASSWORD_FORM_DATA_NORMALIZER = new InjectionToken<
    Converter<any, SetUpPasswordFormData>
    >('BrainTreeSetUpPasswordFormDataNormalizer');

export const BRAINTREE_EXPIRE_STATUS_MESSAGE_DATA_NORMALIZER = new InjectionToken<
    Converter<any, ExpireStatusMessageData>
    >('BrainTreeExpireStatusMessageDataNormalizer');

export const PAYPAL_ADDING_PAYMENT_METHOD_AND_ADDRESS_STATUS_NORMALIZER = new InjectionToken<
    Converter<any, AddingPaymentMethodAndAddressStatusData>
    >('AddingPaymentMethodAndAddressStatusDataNormalizer');
