import {Injectable} from '@angular/core';
import {Observable} from 'rxjs';
import {ConnectAdapter} from './connect.adapter';
import {
  AddingPaymentMethodAndAddressStatusData,
  Fields,
  PageType,
  PayPalConnectB2BData,
  PayPalConnectB2BRegisterData,
  PayPalConnectData,
  PayPalConnectLoginData, PayPalPaymentRequest
} from '../models';

@Injectable()
export class PaypalConnectConnector {

  constructor(protected adapter: ConnectAdapter) {
  }

  exchangeAuthorizationCode(
      authorizationToken: string,
      userId: string,
  ): Observable<PayPalConnectData> {
    return this.adapter.exchangeAuthorizationCode(authorizationToken, userId);
  }

  login(
      accessTokenGuid: string,
      userId: string
  ): Observable<PayPalConnectLoginData> {
    return this.adapter.login(accessTokenGuid, userId);
  }

  afterLogin(
      accessTokenGuid: string,
      userId: string
  ): Observable<boolean> {
    return this.adapter.afterLogin(accessTokenGuid, userId);
  }

  register(
      accessTokenGuid: string,
      userId: string
  ): Observable<string> {
    return this.adapter.register(accessTokenGuid, userId);
  }

  exchangeAuthorizationCodeB2B(
      authorizationToken: string,
      userId: string
  ): Observable<PayPalConnectB2BData> {
    return this.adapter.exchangeAuthorizationCodeB2B(authorizationToken, userId);
  }

  registerB2BCustomer(
      registerData: PayPalConnectB2BRegisterData,
      userId: string
  ): Observable<string> {
    return this.adapter.registerB2BCustomer(registerData, userId);
  }

  savePaymentDetailsAndAddressForNewUser(
      accessTokenGuid:string,
      payPalRequest: PayPalPaymentRequest,
      shouldSaveAddressInfo: boolean,
      shouldSavePaymentInfo: boolean,
      userId: string,
      cartId?: string,
      deviceData?: string,
      fields?: Fields,
      fundingSource?: string
  ): Observable<AddingPaymentMethodAndAddressStatusData> {
    return this.adapter.savePaymentDetailsAndAddressForNewUser(accessTokenGuid, payPalRequest, shouldSaveAddressInfo,
    shouldSavePaymentInfo,userId, cartId, deviceData, fundingSource);
  }
}
