import {Observable} from 'rxjs';
import {BraintreeButtonStyle, DropInButtonStyle, PayPalButtonStyle} from '../models/paypal-button-style.model';
import {BraintreeAssets, CheckoutData} from '../models/braintree-payment-data.model';

export abstract class PaymentAdapter{

  abstract loadPaymentDetails(
    paymentMethod: string,
    userId: string,
    cartId?: string,
    pageType?: string
  ): Observable<CheckoutData>;

  abstract getBraintreeButtonStyles(
    userId: string,
    buttonType?: string
  ): Observable<BraintreeButtonStyle>;

  abstract getDropInButtonStyle(
      userId: string,
      buttonType?: string
  ): Observable<DropInButtonStyle>;

  abstract getBraintreeAssets(): Observable<BraintreeAssets>;

}
