import {Observable} from "rxjs";
import {
  AddingPaymentMethodAndAddressStatusData, Fields, PageType, PayPalConnectB2BData,
  PayPalConnectB2BRegisterData,
  PayPalConnectData,
  PayPalConnectLoginData, PayPalPaymentRequest
} from '../models';

export abstract class ConnectAdapter {

  abstract exchangeAuthorizationCode(
      authorizationToken: string,
      userId: string
  ): Observable<PayPalConnectData>;

  abstract login(
      accessTokenGuid: string,
      userId: string
  ): Observable<PayPalConnectLoginData>;

  abstract afterLogin(
      accessTokenGuid: string,
      userId: string
  ): Observable<boolean>

  abstract register(
      accessTokenGuid: string,
      userId: string
  ): Observable<string>;

  abstract exchangeAuthorizationCodeB2B(
      authorizationToken: string,
      userId: string
  ): Observable<PayPalConnectB2BData>;

  abstract registerB2BCustomer(
      registerData: PayPalConnectB2BRegisterData,
      userId: string
  ): Observable<string>;

  abstract savePaymentDetailsAndAddressForNewUser(
      accessTokenGuid:string,
      payPalRequest: PayPalPaymentRequest,
      shouldSaveAddressInfo: boolean,
      shouldSavePaymentInfo: boolean,
      userId: string,
      cartId?: string,
      deviceData?: string,
      fundingSource?: string
  ): Observable<AddingPaymentMethodAndAddressStatusData>;

}
