import {Injectable} from '@angular/core';
import {SetUpPasswordFormData} from '../models';
import {Observable} from 'rxjs';
import {UserAdapter} from "./user.adapter";

@Injectable()
export class BraintreeUserConnector {

    constructor(
        protected userAdapter: UserAdapter
    ) {}

    getSetUpPasswordFormData(
        userId: string
    ): Observable<SetUpPasswordFormData> {
        return this.userAdapter.getSetUpPasswordFormData(userId);
    }

    setUpPasswordForPayPalCustomer(
        newPassword: string,
        userId: string
    ): Observable<any> {
        return this.userAdapter.setUpPasswordForPayPalCustomer(newPassword,userId);
    }
}