import {Observable} from 'rxjs';
import {Injectable} from '@angular/core';
import {BraintreeButtonStyle, DropInButtonStyle, PayPalButtonStyle} from '../models/paypal-button-style.model';
import {BraintreeAssets, CheckoutData} from '../models/braintree-payment-data.model';
import {PaymentAdapter} from './payment.adapter';

@Injectable()
export class BraintreePaymentConnector{
  constructor(protected adapter: PaymentAdapter) {}

  loadPaymentDetails(
    paymentMethod: string,
    userId: string,
    cartId?: string,
    pageType?: string
  ): Observable<CheckoutData> {
    return this.adapter.loadPaymentDetails(paymentMethod, userId, cartId, pageType);
  }

  getBraintreeButtonStyles(
    userId: string,
    buttonType?: string,
  ): Observable<BraintreeButtonStyle>{
    return this.adapter.getBraintreeButtonStyles(userId, buttonType);
  }

  getDropInButtonStyle(
      userId: string,
      buttonType?: string,
  ): Observable<DropInButtonStyle>{
    return this.adapter.getDropInButtonStyle(userId, buttonType);
  }

  getBraintreeAssets(): Observable<BraintreeAssets>{
    return this.adapter.getBraintreeAssets();
  }


}
