import {Injectable} from '@angular/core';
import {BraintreeCheckoutAdapter} from './braintree-checkout.adapter';
import {Address} from '@spartacus/core';
import {Observable} from 'rxjs';
import {PriceValueData} from '../models';


@Injectable()
export class BraintreeCheckoutConnector {

  constructor(protected adapter: BraintreeCheckoutAdapter) {}

  proceedExpressCheckout(
      paymentDetailsId: string,
      userId: string,
      cartId: string,
      address: Address
  ): Observable<boolean> {
    return this.adapter.proceedExpressCheckout(paymentDetailsId, userId, cartId, address);
  }

  countDeliveryPrice(
      countryCode: string,
      userId: string,
      cartId: string
  ): Observable<PriceValueData> {
    return this.adapter.countDeliveryPrice(countryCode, userId, cartId);
  }

}
