import { Injectable } from '@angular/core';
import {Address, Converter} from '@spartacus/core';
import {GooglePayAddress} from '../../models/braintree-payment-methods.model';

@Injectable({
  providedIn: 'root'
})
export class GooglePayAddressSerializer implements Converter<GooglePayAddress, Address> {

  convert(source: GooglePayAddress, target?: Address): Address {
    if (target === undefined) {
      target = {};
    }
    target.country = {
      isocode: source.countryCode
    };
    target.region = {
      isocode : source.countryCode + '-' + source.administrativeArea
    };

    target.firstName = source.name.split(' ').slice(0, -1).join(' ');
    target.lastName = source.name.split(' ').slice(-1).join(' ');
    target.town = source.locality;
    target.line1 = source.address1;
    target.line2 = source.address2;
    target.phone = source.phoneNumber;
    target.postalCode = source.postalCode;

    return target;
  }
}
