import { ApplePayAddress } from '../../models';
import { Injectable } from '@angular/core';
import { Address, Converter } from '@spartacus/core';

@Injectable({
  providedIn: 'root'
})
export class ApplePayAddressSerializer implements Converter<ApplePayAddress, Address> {

  convert(source: ApplePayAddress, target?: Address): Address {
    if (target === undefined) {
      target = {};
    }
    target.country = {
      isocode: source.countryCode.toUpperCase()
    };
    target.region = {
      isocode : source.countryCode.toUpperCase() + '-' + source.administrativeArea.toUpperCase()
    };

    target.firstName = source.givenName;
    target.lastName = source.familyName;
    target.town = source.locality;
    target.phone = source.phoneNumber;
    target.email = source.emailAddress;
    target.line1 = source.addressLines[0];
    if (source.addressLines.length > 1 && source.addressLines[1] !== null) {
      target.line2 = source.addressLines[1];
    }
    target.postalCode = source.postalCode;

    return target;
  }
}
