import {ModuleWithProviders, NgModule} from '@angular/core';
import {EffectsModule} from '@ngrx/effects';
import {BraintreeCheckoutEffect} from './effects/braintree-checkout.effect';
import {StoreModule} from '@ngrx/store';
import {reducerProvider, reducerToken} from './reducers/index';
import {PAYMENT_DETAILS_FEATURE} from './braintree-payment-details-state';


@NgModule({
  declarations: [],
  imports: [
    EffectsModule.forFeature([BraintreeCheckoutEffect]),
    StoreModule.forFeature(PAYMENT_DETAILS_FEATURE, reducerToken ),
  ],
  providers: [reducerProvider]
})
export class BraintreeCheckoutStoreModule {
  static forRoot(): ModuleWithProviders<BraintreeCheckoutStoreModule> {
    return {
      ngModule: BraintreeCheckoutStoreModule,
    };
  }
}
