import {Action} from '@ngrx/store';
import {
  Address,
  PROCESS_FEATURE,
  StateUtils
} from '@spartacus/core';
import {
  SET_DELIVERY_ADDRESS_PROCESS_ID,
  SET_SUPPORTED_DELIVERY_MODE_PROCESS_ID,
} from '@spartacus/checkout/core';


export const SENT_DELIVERY_MODE_WAS_DELETED_SUCCESS = 'Sent event that delivery mode was deleted success';
export const BRAINTREE_ADD_DELIVERY_ADDRESS = '[Braintree Checkout] Add Delivery Address';
export const BRAINTREE_SET_DELIVERY_ADDRESS = '[Braintree Checkout] Set Delivery Address';
export const BRAINTREE_LOAD_SUPPORTED_DELIVERY_MODES = '[Braintree Checkout] Load Supported Delivery Modes';


export class SentDeliveryModeWasDeletedSuccess implements Action {
  readonly type = SENT_DELIVERY_MODE_WAS_DELETED_SUCCESS;

  constructor() {
  }
}

export class BraintreeAddDeliveryAddress implements Action {
  readonly type = BRAINTREE_ADD_DELIVERY_ADDRESS;

  constructor(
      public payload: { userId: string; cartId: string; address: Address }
  ) {
  }
}

export class BraintreeSetDeliveryAddress extends StateUtils.EntityLoadAction {
  readonly type = BRAINTREE_SET_DELIVERY_ADDRESS;

  constructor(
      public payload: { userId: string; cartId: string; address: Address }
  ) {
    super(PROCESS_FEATURE, SET_DELIVERY_ADDRESS_PROCESS_ID);
  }
}

export class BraintreeLoadSupportedDeliveryModes extends StateUtils.EntityLoadAction {
  readonly type = BRAINTREE_LOAD_SUPPORTED_DELIVERY_MODES;

  constructor(public payload: { userId: string; cartId: string }) {
    super(PROCESS_FEATURE, SET_SUPPORTED_DELIVERY_MODE_PROCESS_ID);
  }
}

export type BraintreeCheckoutAction =
    | SentDeliveryModeWasDeletedSuccess
    | BraintreeAddDeliveryAddress
    | BraintreeSetDeliveryAddress
    | BraintreeLoadSupportedDeliveryModes;
