import { NgModule } from '@angular/core';
import { CheckoutOccModule } from '@spartacus/checkout/occ';

import {
  AnonymousConsentsModule,
  AuthModule,
  CartModule,
  CartOccModule,
  CostCenterOccModule, ExternalRoutesModule, OrderOccModule,
  ProductModule,
  ProductOccModule,
  UserOccModule, UserOccTransitional_4_2_Module, UserTransitional_4_2_Module
} from '@spartacus/core';
import { CheckoutCoreModule } from '@spartacus/checkout/core';
import {
  AddressBookModule,
  AnonymousConsentManagementBannerModule,
  AnonymousConsentsDialogModule,
  BannerCarouselModule,
  BannerModule,
  BreadcrumbModule, CartComponentModule, CartPageEventModule,
  CategoryNavigationModule,
  CmsParagraphModule,
  ConsentManagementModule,
  FooterNavigationModule,
  HamburgerMenuModule, HomePageEventModule,
  LinkModule,
  LoginRouteModule,
  LogoutModule,
  MiniCartModule,
  MyCouponsModule,
  MyInterestsModule, NavigationEventModule,
  NavigationModule,
  NotificationPreferenceModule,
  PaymentMethodsModule,
  ProductCarouselModule,
  ProductDetailsPageModule,
  ProductFacetNavigationModule, ProductImagesModule, ProductIntroModule,
  ProductListingPageModule,
  ProductListModule, ProductPageEventModule, ProductReferencesModule, ProductSummaryModule, ProductTabsModule,
  SearchBoxModule,
  SiteContextSelectorModule,
  StockNotificationModule,
  TabParagraphContainerModule, WishListModule
} from '@spartacus/storefront';
import { UserFeatureModule } from './features/user/user-feature.module';
import { CheckoutFeatureModule } from './features/checkout/checkout-feature.module';
import { OrderFeatureModule } from './features/order/order-feature.module';


@NgModule({
  imports: [
    AuthModule.forRoot(),
    LogoutModule,
    LoginRouteModule,
    HamburgerMenuModule,
    SiteContextSelectorModule,
    LinkModule,
    BannerModule,
    CmsParagraphModule,
    TabParagraphContainerModule,
    BannerCarouselModule,
    CategoryNavigationModule,
    NavigationModule,
    FooterNavigationModule,
    BreadcrumbModule,
    UserTransitional_4_2_Module,
    UserOccTransitional_4_2_Module,
    AddressBookModule,
    PaymentMethodsModule,
    NotificationPreferenceModule,
    MyInterestsModule,
    StockNotificationModule,
    ConsentManagementModule,
    MyCouponsModule,
    AnonymousConsentsModule.forRoot(),
    AnonymousConsentsDialogModule,
    AnonymousConsentManagementBannerModule,
    ProductModule.forRoot(),
    ProductOccModule,
    ProductDetailsPageModule,
    ProductListingPageModule,
    ProductListModule,
    SearchBoxModule,
    ProductFacetNavigationModule,
    ProductTabsModule,
    ProductCarouselModule,
    ProductReferencesModule,
    ProductImagesModule,
    ProductSummaryModule,
    ProductIntroModule,
    // Cart Core,
    CartModule.forRoot(),
    CartOccModule,
    MiniCartModule,
    CartComponentModule,
    WishListModule,
    CostCenterOccModule,
    OrderOccModule,
    UserOccModule,
    CheckoutOccModule,
    CheckoutCoreModule,
    NavigationEventModule,
    HomePageEventModule,
    CartPageEventModule,
    ProductPageEventModule,
    ExternalRoutesModule.forRoot(),

    UserFeatureModule,
     CheckoutFeatureModule,
     OrderFeatureModule,
  ]
})
export class SpartacusFeaturesModule { }
