import {NgModule} from '@angular/core';
import {provideConfig, provideDefaultConfig} from '@spartacus/core';
import {defaultCmsContentProviders, layoutConfig, mediaConfig} from '@spartacus/storefront';
import {translationChunksConfig, translations} from '@spartacus/assets';
import {BraintreeStorefrontModule, defaultBraintreeCheckoutConfig} from 'braintree-spartacus-storefront';

@NgModule({
  imports: [
    BraintreeStorefrontModule.withConfig({
      braintreeCheckout: {
        allowGuestExpressCheckout: true
      }
    }),
  ],
  providers: [
    provideConfig(layoutConfig),
    provideConfig(mediaConfig),
    ...defaultCmsContentProviders,
    provideConfig({
      backend: {
        occ: {
          baseUrl: 'https://localhost:9002',
          prefix: '/rest/v2/'
        }
      },
      context: {
        currency: ['USD', 'JPY', 'EUR'],
        language: ['en'],
        baseSite: ['electronics-spa']
      },
      i18n: {
        resources: translations,
        chunks: translationChunksConfig,
        fallbackLang: 'en'
      },
      checkout: {
        guest: true
      },
      features: {
        level: '4.3'
      },
    }),
    provideDefaultConfig(defaultBraintreeCheckoutConfig)
  ]
})
export class SpartacusConfigurationModule { }
