import { NgModule } from '@angular/core';
import { translationChunksConfig, translations } from '@spartacus/assets';
import { provideConfig, provideDefaultConfig } from '@spartacus/core';
import {
  organizationTranslationChunksConfig,
  organizationTranslations
} from '@spartacus/organization/administration/assets';
import {
  orderApprovalTranslationChunksConfig,
  orderApprovalTranslations
} from '@spartacus/organization/order-approval/assets';
import { defaultB2bCheckoutConfig, defaultB2bOccConfig } from '@spartacus/setup';
import { defaultCmsContentProviders, layoutConfig, mediaConfig } from '@spartacus/storefront';
import { BraintreeStorefrontModule } from 'braintree-spartacus-storefront';

@NgModule({
  imports: [
    BraintreeStorefrontModule.withConfig({
      braintreeCheckout: {
        allowGuestExpressCheckout: false
      }
    }),
  ],
  providers: [
    provideConfig(layoutConfig),
    provideConfig(mediaConfig),
    ...defaultCmsContentProviders,
    provideConfig({
      featureModules: {
        organizationOrderApproval: {
          module: () => import('@spartacus/organization/order-approval').then(
            (m) => m.OrderApprovalModule
          ),
        },
        organizationAdministration: {
          module: () => import('@spartacus/organization/administration').then(
            (m) => m.AdministrationModule
          ),
        },
      },
      backend: {
        occ: {
          baseUrl: 'https://localhost:9002',
          prefix: '/rest/v2/'
        }
      },
      context: {
        currency: ['USD', 'JPY', 'EUR'],
        language: ['en'],
        baseSite: ['powertools-spa']
      },
      i18n: {
        resources: translations,
        chunks: translationChunksConfig,
        fallbackLang: 'en'
      },
      features: {
        level: '3.1'
      }
    }),
    provideDefaultConfig(defaultB2bOccConfig),
    provideConfig(defaultB2bCheckoutConfig),
    provideConfig({
      i18n: {
        resources: organizationTranslations,
        chunks: organizationTranslationChunksConfig,
      },
    }),
    provideConfig({
      i18n: {
        resources: orderApprovalTranslations,
        chunks: orderApprovalTranslationChunksConfig,
      },
    }),
    provideConfig(defaultB2bOccConfig)
  ]
})
export class SpartacusConfigurationModule { }
