import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';

import { AppComponent } from './app.component';
import { AdministrationRootModule } from '@spartacus/organization/administration/root';
import { OrderApprovalRootModule } from '@spartacus/organization/order-approval/root';
import {SpartacusModule} from './spartacus/spartacus.module';
import {EffectsModule} from '@ngrx/effects';
import {StoreModule} from '@ngrx/store';
import {HttpClientModule} from "@angular/common/http";
import {AuthModule} from "@spartacus/core";
import {AppRoutingModule} from "@spartacus/storefront";


@NgModule({
  declarations: [
    AppComponent
  ],
  imports: [
    BrowserModule,
    AppRoutingModule,
    AuthModule.forRoot(),
    StoreModule.forRoot({}),
    EffectsModule.forRoot([]),
    HttpClientModule,
    SpartacusModule,
    AdministrationRootModule,
    OrderApprovalRootModule
  ],
  bootstrap: [AppComponent]
})
export class AppModule { }
