/**
 *
 */
package com.braintree.controllers;


import com.braintree.facade.impl.DefaultBrainTreeCheckoutFacade;
import com.braintree.facade.impl.DefaultBrainTreePaymentFacade;
import com.braintreegateway.LocalPaymentReversed;
import com.braintreegateway.WebhookNotification;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.order.InvalidCartException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.*;

@UnitTest
public class BraintreeWebhookListenerTest {

    @Mock
    DefaultBrainTreePaymentFacade brainTreePaymentFacade;

    @Mock
    private DefaultBrainTreeCheckoutFacade brainTreeCheckoutFacade;

    @InjectMocks
    BraintreeWebhookListener braintreeWebhookListener;

    private static final String PAYMENT_ID = "testId";

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void handleLocalPaymentRefund() throws InvalidCartException {
        WebhookNotification webhookNotification = Mockito.mock(WebhookNotification.class);
        LocalPaymentReversed localPaymentReversed = mock(LocalPaymentReversed.class);
        OrderModel orderModel = Mockito.mock(OrderModel.class);

        when(localPaymentReversed.getPaymentId()).thenReturn(PAYMENT_ID);
        when(webhookNotification.getLocalPaymentReversed()).thenReturn(localPaymentReversed);
        when(webhookNotification.getKind()).thenReturn(WebhookNotification.Kind.LOCAL_PAYMENT_REVERSED);

        when(brainTreePaymentFacade.getWebhookNotification(any())).thenReturn(webhookNotification);
        when(brainTreePaymentFacade.getOrderByPaymentId(PAYMENT_ID)).thenReturn(orderModel);


        ResponseEntity<String> handleLocalPaymentRefundResult = braintreeWebhookListener
                .handleLocalPaymentRefund(mock(HttpServletRequest.class), mock(HttpServletResponse.class));

        verify(brainTreePaymentFacade, times(1)).getOrderByPaymentId(PAYMENT_ID);
        verify(brainTreePaymentFacade, times(1)).getWebhookNotification(any());

        Assert.assertEquals(HttpStatus.OK, handleLocalPaymentRefundResult.getStatusCode());

    }
}
