package com.braintree.validators.impl;

import static com.braintree.constants.BraintreeoccaddonWebConstants.FIELD_REQUIRED_MESSAGE_ID;

import com.braintree.hybris.data.ws.PayPalDetailsWsDTO;
import com.braintree.validators.BrainTreeValidator;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

public class BraintreePayPalDetailsValidator implements BrainTreeValidator {

    @Override
    public boolean supports(final Class clazz) {
        return PayPalDetailsWsDTO.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(final Object target, final Errors errors) {

        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "email", FIELD_REQUIRED_MESSAGE_ID);
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "firstName", FIELD_REQUIRED_MESSAGE_ID);
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "lastName", FIELD_REQUIRED_MESSAGE_ID);
    }

}
