package com.braintree.validators.impl;

import com.braintree.hybris.data.ws.GooglePayPaymentRequestWsDTO;
import com.braintree.validators.BrainTreeValidator;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

import static com.braintree.constants.BraintreeoccaddonWebConstants.FIELD_REQUIRED_MESSAGE_ID;

public class BraintreeGooglePayPaymentRequestValidator implements BrainTreeValidator {

    private Validator paymentAddressValidator;

    @Override
    public boolean supports(Class<?> clazz) {
        return GooglePayPaymentRequestWsDTO.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(Object target, Errors errors) {
        final GooglePayPaymentRequestWsDTO paymentResponse = (GooglePayPaymentRequestWsDTO) target;

        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "nonce", FIELD_REQUIRED_MESSAGE_ID);
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "type", FIELD_REQUIRED_MESSAGE_ID);
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "email", FIELD_REQUIRED_MESSAGE_ID);

        Assert.notNull(paymentResponse.getBillingAddress(), "BillingAddress object must not be null");
        validate(paymentResponse.getBillingAddress(), "billingAddress", getPaymentAddressValidator());
    }

    public Validator getPaymentAddressValidator() {
        return paymentAddressValidator;
    }

    public void setPaymentAddressValidator(Validator paymentAddressValidator) {
        this.paymentAddressValidator = paymentAddressValidator;
    }
}
