package com.braintree.validators.impl;

import com.braintree.hybris.data.ws.BraintreeCreditCardPaymentDetailsWsDTO;
import com.braintree.validators.BrainTreeValidator;
import de.hybris.platform.ycommercewebservices.validator.PaymentDetailsDTOValidator;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class BraintreeCreditCardPaymentResponseValidator extends PaymentDetailsDTOValidator implements BrainTreeValidator {

    private Validator creditCardDataValidator;

    @Override
    public boolean supports(Class aClass) {
        return BraintreeCreditCardPaymentDetailsWsDTO.class.isAssignableFrom(aClass);
    }

    @Override
    public void validate(Object target, Errors errors) {

        final BraintreeCreditCardPaymentDetailsWsDTO creditCardPaymentDetails = (BraintreeCreditCardPaymentDetailsWsDTO) target;

        super.validate(creditCardPaymentDetails, errors);

        Assert.notNull(creditCardPaymentDetails.getTokenizedCardData(), "Tokenized credit card data must not be null");
        validate(creditCardPaymentDetails.getTokenizedCardData(), "tokenizedCardData", getCreditCardDataValidator());
    }

    public Validator getCreditCardDataValidator() {
        return creditCardDataValidator;
    }

    public void setCreditCardDataValidator(Validator creditCardDataValidator) {
        this.creditCardDataValidator = creditCardDataValidator;
    }
}
