/**
 *
 */
package com.braintree.filters;

import de.hybris.platform.commerceservices.enums.CustomerType;
import de.hybris.platform.commerceservices.order.CommerceCartService;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.core.model.user.UserModel;
import de.hybris.platform.servicelayer.user.UserService;
import de.hybris.platform.site.BaseSiteService;
import java.util.Optional;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * This filter sets Customer into session using cartGuid.
 */
public class BraintreeGuestRoleFilter extends OncePerRequestFilter {

    private static final String CART_GUID = "cartGuid";

    private CommerceCartService commerceCartService;

    private BaseSiteService baseSiteService;

    private UserService userService;

    @Override
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse,
        FilterChain filterChain) throws ServletException, IOException {

        Optional.ofNullable(httpServletRequest.getParameter(CART_GUID)).ifPresent(cartGuid->{
            CartModel cartModel = commerceCartService
                .getCartForGuidAndSite(cartGuid, baseSiteService.getCurrentBaseSite());
            if (cartModel != null && getUserService().isAnonymousUser(getUserService().getCurrentUser())) {
                final UserModel um = cartModel.getUser();
                if (um != null && CustomerModel.class.isAssignableFrom(um.getClass())) {
                    final CustomerModel cm = (CustomerModel) um;
                    if (isGuest(cm)) {
                        getUserService().setCurrentUser(cm);
                    }
                }

            }
        });

        filterChain.doFilter(httpServletRequest, httpServletResponse);
    }

    protected boolean isGuest(final CustomerModel cm) {
        if (cm == null || cm.getType() == null) {
            return false;
        }
        if (cm.getType().toString().equals(CustomerType.GUEST.getCode())) {
            return true;
        }
        return false;
    }


    public CommerceCartService getCommerceCartService() {
        return commerceCartService;
    }

    public void setCommerceCartService(CommerceCartService commerceCartService) {
        this.commerceCartService = commerceCartService;
    }

    public BaseSiteService getBaseSiteService() {
        return baseSiteService;
    }

    public void setBaseSiteService(BaseSiteService baseSiteService) {
        this.baseSiteService = baseSiteService;
    }

    public UserService getUserService() {
        return userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}
