/**
 *
 */
package braintreehac.services;


import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.catalog.CatalogVersionService;
import de.hybris.platform.catalog.model.CatalogModel;
import de.hybris.platform.catalog.model.CatalogVersionModel;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.contents.components.SimpleCMSComponentModel;
import de.hybris.platform.cms2.servicelayer.services.CMSComponentService;
import de.hybris.platform.cms2.servicelayer.services.CMSSiteService;
import de.hybris.platform.cms2.servicelayer.services.admin.CMSAdminSiteService;
import de.hybris.platform.cmsfacades.cmsitems.CMSItemFacade;
import java.util.HashMap;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class BrainTreePayPalCreditMessageConfigurationServiceTest {

    @Mock
    private CatalogVersionService catalogVersionService;

    @Mock
    private CMSSiteService cmsSiteService;

    @Mock
    private CMSItemFacade cmsItemFacade;

    @Mock
    private CMSAdminSiteService cmsAdminSiteService;

    @Mock
    private CMSComponentService cmsComponentService;

    @Mock
    private BrainTreeCatalogSynchronizationService brainTreeCatalogSynchronizationService;

    @InjectMocks
    private BrainTreePayPalCreditMessageConfigurationService unit;

    private static final String COMPONENT_UID = "componentUid";
    private static final String COMPONENT_UID_B2B = "componentUidB2B";
    private static final String COMPONENT_UID_SPA = "componentUidSPA";
    private static final String MESSAGE = "message";

    @Before
    public void setUp() throws CMSItemNotFoundException {
        MockitoAnnotations.initMocks(this);
        SimpleCMSComponentModel cmsComponentModel = Mockito.mock(SimpleCMSComponentModel.class);
        CatalogVersionModel catalogVersionModel = Mockito.mock(CatalogVersionModel.class);
        CatalogModel catalogModel = Mockito.mock(CatalogModel.class);

        when(catalogVersionModel.getCatalog()).thenReturn(catalogModel);
        when(cmsComponentModel.getCatalogVersion()).thenReturn(catalogVersionModel);

        when(cmsComponentService.getSimpleCMSComponent(COMPONENT_UID)).thenReturn(cmsComponentModel);
        when(cmsComponentService.getSimpleCMSComponent(COMPONENT_UID_B2B))
            .thenThrow(new CMSItemNotFoundException(MESSAGE));
        when(cmsComponentService.getSimpleCMSComponent(COMPONENT_UID_SPA))
            .thenThrow(new CMSItemNotFoundException(MESSAGE));

        Map<String, Object> stringObjectMap = new HashMap<>();
        stringObjectMap.put("uuid", new Object());
        when(cmsItemFacade.getCMSItemByUuid(any())).thenReturn(stringObjectMap);
        when(cmsAdminSiteService.getActiveCatalogVersion()).thenReturn(catalogVersionModel);
    }

    @Test
    public void processComponentUpdatingShouldCallSynchronizeItemsOnSynchronizationService() {
        Map<String, String[]> refreshedParameters = new HashMap<>();

        unit.processComponentUpdating(COMPONENT_UID, refreshedParameters);
        verify(brainTreeCatalogSynchronizationService).synchronizeItems(any(), any(), any());
    }

    @Test
    public void processNormalRequestShouldNotThrowExceptions() {
        unit.processNormalRequest();
    }
}
