/**
 *
 */
package braintreehac.services;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.braintree.enums.BraintreePageType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.braintreehac.data.PayPalButtonStyleData;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class BrainTreePayPalButtonConfigurationServiceTest {

    @Mock
    private Properties prop;

    @Mock
    private ObjectMapper mapper;

    @InjectMocks
    private BrainTreePayPalButtonConfigurationService unit;

    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String BUTTON_CONFIG = "buttonConfig";
    private static final String HEIGHT = "height";
    private static final String HEIGHT_NUMBER = "120";
    private static final String MARK_BUTTON_CONFIG = "mark.button.config";

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void setPropertyShouldUseMethodSetProperty() {
        unit.setProperty(KEY, VALUE);
        verify(prop).setProperty(KEY, VALUE);
    }

    @Test
    public void setDefaultButtonConfigsWithInvalidKeyShouldNotUseSetProperty() {
        unit.setDefaultButtonConfigs(KEY);
        verify(prop, never()).setProperty(any(), any());
    }

    @Test
    public void handleStyleDataUpdateShouldUseSetProperty() {
        HttpServletRequest request = Mockito.mock(HttpServletRequest.class);
        when(request.getParameter(HEIGHT)).thenReturn(HEIGHT_NUMBER);
        unit.handleStyleDataUpdate(request, BUTTON_CONFIG);
        verify(prop).setProperty(any(), any());
    }

    @Test
    public void getPayPalButtonStyleByPageTypeShouldReturnExceptedStyle() throws JsonProcessingException {
        PayPalButtonStyleData payPalButtonStyleData = Mockito.mock(PayPalButtonStyleData.class);
        when(prop.getProperty(MARK_BUTTON_CONFIG)).thenReturn(MARK_BUTTON_CONFIG);
        when(mapper.readValue(MARK_BUTTON_CONFIG, PayPalButtonStyleData.class)).thenReturn(payPalButtonStyleData);

        Assert.assertEquals(payPalButtonStyleData, unit.getPayPalButtonStyleByPageType(BraintreePageType.MARK));
    }
}
