/**
 *
 */
package braintreehac.services;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.catalog.model.CatalogModel;
import de.hybris.platform.catalog.model.CatalogVersionModel;
import de.hybris.platform.catalog.model.SyncItemJobModel;
import de.hybris.platform.catalog.synchronization.CatalogSynchronizationService;
import de.hybris.platform.catalog.synchronization.SyncConfig;
import de.hybris.platform.catalog.synchronization.SynchronizationStatusService;
import de.hybris.platform.core.model.ItemModel;
import de.hybris.platform.servicelayer.session.SessionService;
import de.hybris.platform.servicelayer.type.TypeService;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class BrainTreeCatalogSynchronizationServiceTest {

    @Mock
    private SynchronizationStatusService platformSynchronizationStatusService;

    @Mock
    private SessionService sessionService;

    @Mock
    private TypeService typeService;

    @Mock
    private SyncConfig syncConfig;

    @Mock
    private CatalogSynchronizationService catalogSynchronizationService;

    @InjectMocks
    private BrainTreeCatalogSynchronizationService unit;

    private static final String SOURCE_VERSION = "sourceVersion";

    private static final String TARGET_VERSION = "targetVersion";

    private SyncItemJobModel syncItemJobModel;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        syncItemJobModel = Mockito.mock(SyncItemJobModel.class);
        List<SyncItemJobModel> syncItemJobModels = new ArrayList<>();
        syncItemJobModels.add(syncItemJobModel);
        CatalogVersionModel sourceCatalog = Mockito.mock(CatalogVersionModel.class);
        CatalogVersionModel targetCatalog = Mockito.mock(CatalogVersionModel.class);
        when(sourceCatalog.getVersion()).thenReturn(SOURCE_VERSION);
        when(targetCatalog.getVersion()).thenReturn(TARGET_VERSION);

        when(syncItemJobModel.getSourceVersion()).thenReturn(sourceCatalog);
        when(syncItemJobModel.getTargetVersion()).thenReturn(targetCatalog);
        when(platformSynchronizationStatusService.getOutboundSynchronizations(any())).thenReturn(syncItemJobModels);
    }

    @Test
    public void synchronizeItemsShouldPerformSynchronization() {
        ItemModel itemModel = Mockito.mock(ItemModel.class);
        List<ItemModel> itemsToSynchronize = new ArrayList<>();
        itemsToSynchronize.add(itemModel);
        CatalogVersionModel source = Mockito.mock(CatalogVersionModel.class);
        CatalogVersionModel target = Mockito.mock(CatalogVersionModel.class);
        CatalogModel sourceCatalog = Mockito.mock(CatalogModel.class);

        when(source.getVersion()).thenReturn(SOURCE_VERSION);
        when(target.getVersion()).thenReturn(TARGET_VERSION);
        when(sessionService.<Boolean>executeInLocalView(any())).thenReturn(Boolean.TRUE);
        when(source.getCatalog()).thenReturn(sourceCatalog);

        unit.synchronizeItems(itemsToSynchronize, source, target);
        verify(catalogSynchronizationService).performSynchronization(itemsToSynchronize, syncItemJobModel, syncConfig);
    }
}
