package de.hybris.platform.hac.controller;

import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.contents.components.SimpleCMSComponentModel;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import braintreehac.services.BrainTreePayPalCreditMessageConfigurationService;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;


@Controller
@RequestMapping("/braintreehac")
public class BraintreePayPalCreditMessageConfigurationController {

    private static final String REDIRECT_PREFIX = "redirect:";
    private static final String PRODUCT_GRID_CREDIT_MESSAGE = "PayPalProductGridCreditMessageComponent";
    private static final String PRODUCT_LIST_CREDIT_MESSAGE = "PayPalProductListCreditMessageComponent";
    private static final String PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE = "PayPalProductDetailsPageCreditMessageComponent";
    private static final String CART_PAGE_CREDIT_MESSAGE = "PayPalCartPageCreditMessageComponent";
    private static final String REDIRECTION_TO_GRID_CREDIT_MESSAGE_URL = "/braintreehac/productGridCreditMessage/config";
    private static final String REDIRECTION_TO_LIST_CREDIT_MESSAGE_URL = "/braintreehac/productListCreditMessage/config";
    private static final String REDIRECTION_TO_PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE_URL = "/braintreehac/productDetailsPageCreditMessage/config";
    private static final String REDIRECTION_TO_CART_PAGE_CREDIT_MESSAGE_URL = "/braintreehac/cartPageCreditMessage/config";
    private static final String CREDIT_MESSAGE = "creditMessage";
    private static final String LABEL = "label";
    private static final String COMPONENT_UID = "componentUid";
    private static final String CREDIT_MESSAGE_CONFIG_PAGE = "creditMessageConfig";

    @Resource(name = "brainTreePayPalCreditMessageConfigurationService")
    private BrainTreePayPalCreditMessageConfigurationService payPalCreditMessageConfigurationService;


    @RequestMapping(value = "/productGridCreditMessage/config", method = RequestMethod.GET)
    public String configureProductGridCreditMessage(HttpServletRequest request, HttpServletResponse response,
        ModelMap model) throws CMSItemNotFoundException {

        payPalCreditMessageConfigurationService.processNormalRequest();

        SimpleCMSComponentModel creditMessageComponent = getCreditMessageByUid(PRODUCT_GRID_CREDIT_MESSAGE);

        model.addAttribute(CREDIT_MESSAGE, payPalCreditMessageConfigurationService
            .getCreditMessageItemByUid(creditMessageComponent));
        model.addAttribute(COMPONENT_UID, PRODUCT_GRID_CREDIT_MESSAGE);
        model.addAttribute(LABEL, "Product List Credit Message configuration");
        setEscentialValues(model);

        return CREDIT_MESSAGE_CONFIG_PAGE;
    }

    @RequestMapping(value = "/productListCreditMessage/config", method = RequestMethod.GET)
    public String configureProductListCreditMessage(HttpServletRequest request, HttpServletResponse response,
        ModelMap model) throws CMSItemNotFoundException {

        payPalCreditMessageConfigurationService.processNormalRequest();

        SimpleCMSComponentModel creditMessageComponent = getCreditMessageByUid(PRODUCT_LIST_CREDIT_MESSAGE);

        model.addAttribute(CREDIT_MESSAGE, payPalCreditMessageConfigurationService
            .getCreditMessageItemByUid(creditMessageComponent));
        model.addAttribute(COMPONENT_UID, PRODUCT_LIST_CREDIT_MESSAGE);
        model.addAttribute(LABEL, "Product List Credit Message configuration");
        setEscentialValues(model);

        return CREDIT_MESSAGE_CONFIG_PAGE;
    }

    @RequestMapping(value = "/productDetailsPageCreditMessage/config", method = RequestMethod.GET)
    public String configureProductDetailPageCreditMessage(HttpServletRequest request, HttpServletResponse response,
        ModelMap model) throws CMSItemNotFoundException {

        payPalCreditMessageConfigurationService.processNormalRequest();

        SimpleCMSComponentModel creditMessageComponent = getCreditMessageByUid(PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE);

        model.addAttribute(CREDIT_MESSAGE,
            payPalCreditMessageConfigurationService.getCreditMessageItemByUid(creditMessageComponent));
        model.addAttribute(COMPONENT_UID, PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE);
        model.addAttribute(LABEL, "Product Details Page Credit Message configuration");
        setEscentialValues(model);

        return CREDIT_MESSAGE_CONFIG_PAGE;
    }

    @RequestMapping(value = "/cartPageCreditMessage/config", method = RequestMethod.GET)
    public String configureCartPageCreditMessage(HttpServletRequest request, HttpServletResponse response,
        ModelMap model) throws CMSItemNotFoundException {

        payPalCreditMessageConfigurationService.processNormalRequest();

        SimpleCMSComponentModel creditMessageComponent = getCreditMessageByUid(CART_PAGE_CREDIT_MESSAGE);

        model.addAttribute(CREDIT_MESSAGE, payPalCreditMessageConfigurationService
            .getCreditMessageItemByUid(creditMessageComponent));
        model.addAttribute(COMPONENT_UID, CART_PAGE_CREDIT_MESSAGE);
        model.addAttribute(LABEL, "Cart Page Credit Message configuration");
        setEscentialValues(model);

        return CREDIT_MESSAGE_CONFIG_PAGE;
    }

    private SimpleCMSComponentModel getCreditMessageByUid(String componentName) {

        SimpleCMSComponentModel creditMessageComponent = payPalCreditMessageConfigurationService
            .getComponentByUid(componentName);
        if (creditMessageComponent == null) {
            creditMessageComponent = payPalCreditMessageConfigurationService.getComponentByUid(componentName + "B2B");
        }

        if (creditMessageComponent == null) {
            creditMessageComponent = payPalCreditMessageConfigurationService.getComponentByUid(componentName + "SPA");
        }

        return creditMessageComponent;
    }

    private void setEscentialValues(ModelMap model) {
        model.addAttribute("layout", payPalCreditMessageConfigurationService.getLayout());
        model.addAttribute("logoType", payPalCreditMessageConfigurationService.getLogoType());
        model.addAttribute("logoPosition", payPalCreditMessageConfigurationService.getLogoPosition());
        model.addAttribute("textColor", payPalCreditMessageConfigurationService.getTextColor());
        model.addAttribute("color", payPalCreditMessageConfigurationService.getColor());
        model.addAttribute("ratio", payPalCreditMessageConfigurationService.getRatio());

    }

    @RequestMapping(value = "/saveConfigs", method = RequestMethod.GET)
    public String saveCreditMessageConfigs(HttpServletRequest request, HttpServletResponse response, ModelMap model) {

        Map<String, String[]> refreshedParameters = new HashMap<>(request.getParameterMap());
        final String creditMessageComponentUid = Arrays.stream(refreshedParameters.get("uid")).findFirst().get();
        refreshedParameters.remove("uid");

        payPalCreditMessageConfigurationService
            .processComponentUpdating(creditMessageComponentUid, refreshedParameters);

        return getRedirectUrl(creditMessageComponentUid);
    }

    private String getRedirectUrl(final String creditMessageUid) {
        String redirectURL = REDIRECT_PREFIX;

        switch (creditMessageUid) {
            case PRODUCT_GRID_CREDIT_MESSAGE:
                redirectURL = redirectURL.concat(REDIRECTION_TO_GRID_CREDIT_MESSAGE_URL);
                break;

            case PRODUCT_LIST_CREDIT_MESSAGE:
                redirectURL = redirectURL.concat(REDIRECTION_TO_LIST_CREDIT_MESSAGE_URL);
                break;

            case PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE:
                redirectURL = redirectURL.concat(REDIRECTION_TO_PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE_URL);
                break;

            case CART_PAGE_CREDIT_MESSAGE:
                redirectURL = redirectURL.concat(REDIRECTION_TO_CART_PAGE_CREDIT_MESSAGE_URL);
                break;

        }

        return redirectURL;
    }

}
