<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<% pageContext.setAttribute("newLineChar", "\n"); %>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Drop-In Button Customization</title>

</head>
<body>
<div class="marginLeft prepend-top span-17">

    <h2>${pageLabel}</h2>

    <div class="dataTable no-footer">
        <form action="/hac/braintreehac/dropIn/config/googlePay/save?placing=${item}" method="GET">
            <div id="placingDropInContainer">
                <label for="placingDropIn"> Choose a placing: </label>
                <select name="placing" id="placingDropIn" onchange="changePlacing(this.value)">
                    <c:forEach var="item" items="${placingDropIn}">
                        <option value="${item}" ${item == placingFromController ? 'selected="selected"' : ''}>${item}</option>
                    </c:forEach>
                </select>
            </div>
            <div id="buttonColorDropIn">
                <label for="buttonColor"> Choose a color: </label>
                <select name="buttonColor" id="buttonColor">
                    <c:forEach var="item" items="${buttonColor}">
                        <option value="${item}" ${item == dropInComponent.buttonColor ? 'selected="selected"' : ''}>${item}</option>
                    </c:forEach>
                </select>
            </div>
            <div id="buttonTypeDropIn">
                <label for="buttonType"> Choose a type: </label>
                <select name="buttonType" id="buttonType">
                    <c:forEach var="item" items="${buttonType}">
                        <option value="${item}" ${item == dropInComponent.buttonType ? 'selected="selected"' : ''}>${item}</option>
                    </c:forEach>
                </select>
            </div>
            <div id="buttonSizeModeDropIn">
                <label for="buttonSizeMode"> Choose a size mode:</label>
                <select name="buttonSizeMode" id="buttonSizeMode">
                    <c:forEach var="item" items="${buttonSizeMode}">
                        <option value="${item}" ${item == dropInComponent.buttonSizeMode ? 'selected="selected"' : ''}>${item}</option>
                    </c:forEach>
                </select>
            </div>
            <br>
            <div style="margin-bottom: 4px">
                <input type="submit" value="Save">
            </div>
            <br>
        </form>
    </div>
</div>

<script>
    function changePlacing(placing) {
        window.location.href = "/hac/braintreehac/dropIn/config/googlePay?placing=" + placing;
    }
</script>

</body>
</html>