/*
 * [y] hybris Platform
 *
 * Copyright (c) 2000-2015 hybris AG
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of hybris
 * ("Confidential Information"). You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of the
 * license agreement you entered into with hybris.
 *
 *
 */
package com.braintree.test;

import static org.mockito.Matchers.any;

import com.braintree.actions.order.BrainTreeNotifyCustomerAboutFraudAction;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.orderprocessing.events.OrderFraudCustomerNotificationEvent;
import de.hybris.platform.orderprocessing.model.OrderProcessModel;
import de.hybris.platform.servicelayer.event.EventService;
import de.hybris.platform.servicelayer.model.ModelService;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;


public class SendOrderFraudCustomerNotificationEventTest {

    @InjectMocks
    private final BrainTreeNotifyCustomerAboutFraudAction action = new BrainTreeNotifyCustomerAboutFraudAction();

    @Mock
    private EventService eventService;
    @Mock
    private ModelService modelService;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void testExecuteAction() {
        final OrderProcessModel process = new OrderProcessModel();
        final OrderModel order = new OrderModel();
        process.setOrder(order);
        action.executeAction(process);
        Mockito.verify(eventService).publishEvent(any(OrderFraudCustomerNotificationEvent.class));

        Mockito.verify(modelService).save(order);
        Assert.assertEquals(OrderStatus.SUSPENDED, order.getStatus());
    }
}
