/*
 * [y] hybris Platform
 *
 * Copyright (c) 2000-2015 hybris AG
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of hybris
 * ("Confidential Information"). You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of the
 * license agreement you entered into with hybris.
 *
 *
 */
package com.braintree.test;

import static org.mockito.Matchers.any;

import com.braintree.actions.order.BrainTreeSendFraudErrorNotificationAction;
import de.hybris.platform.orderprocessing.events.FraudErrorEvent;
import de.hybris.platform.orderprocessing.model.OrderProcessModel;
import de.hybris.platform.servicelayer.event.EventService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;


/**
 *
 */
public class SendFraudErrorNotificationTest {

    @InjectMocks
    private final BrainTreeSendFraudErrorNotificationAction sendFraudErrorNotification = new BrainTreeSendFraudErrorNotificationAction();

    @Mock
    private EventService eventService;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    /**
     * Test method for {@link BrainTreeSendFraudErrorNotificationAction#executeAction(OrderProcessModel)} .
     */
    @Test
    public void testExecuteActionOrderProcessModel() {
        final OrderProcessModel process = new OrderProcessModel();
        sendFraudErrorNotification.executeAction(process);

        Mockito.verify(eventService).publishEvent(any(FraudErrorEvent.class));
    }
}
