/**
 *
 */
package com.braintree.strategy.impl;

import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commerceservices.stock.CommerceStockService;
import de.hybris.platform.core.model.order.AbstractOrderEntryModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.store.BaseStoreModel;
import de.hybris.platform.storelocator.model.PointOfServiceModel;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class BrainTreeSplitByAvailableCountTest {

    @Mock
    private CommerceStockService commerceStockService;

    @InjectMocks
    private BrainTreeSplitByAvailableCount unit;

    private static final Long ZERO = 0L;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void testGetGroupingObjectWithoutDeliveryPointOfService() {
        AbstractOrderEntryModel orderEntryModel = Mockito.mock(AbstractOrderEntryModel.class);
        OrderModel orderModel = Mockito.mock(OrderModel.class);
        BaseStoreModel baseStoreModel = Mockito.mock(BaseStoreModel.class);

        when(orderModel.getStore()).thenReturn(baseStoreModel);
        when(orderEntryModel.getQuantity()).thenReturn(ZERO);
        when(orderEntryModel.getOrder()).thenReturn(orderModel);
        unit.getGroupingObject(orderEntryModel);
    }

    @Test
    public void testGetGroupingObjectWithDeliveryPointOfService() {
        AbstractOrderEntryModel orderEntryModel = Mockito.mock(AbstractOrderEntryModel.class);
        PointOfServiceModel serviceModel = Mockito.mock(PointOfServiceModel.class);
        when(orderEntryModel.getDeliveryPointOfService()).thenReturn(serviceModel);

        unit.getGroupingObject(orderEntryModel);
    }
}
