/*

 */
package com.braintree.email.context;

import com.braintree.model.BraintreeLocalPaymentReversedEmailProcessModel;
import de.hybris.platform.acceleratorservices.model.cms2.pages.EmailPageModel;
import de.hybris.platform.commerceservices.model.process.StoreFrontCustomerProcessModel;
import de.hybris.platform.yacceleratorfacades.process.email.context.CustomerEmailContext;

public class BraintreeLocalPaymentReversedEmailContext extends  CustomerEmailContext{

    private String content;
    private String orderId;
    private String orderTotalPrice;
    private String currency;

    @Override
    public void init(final StoreFrontCustomerProcessModel processModel, final EmailPageModel emailPageModel)
    {
        super.init(processModel, emailPageModel);
        if (processModel instanceof BraintreeLocalPaymentReversedEmailProcessModel){

            setContent(((BraintreeLocalPaymentReversedEmailProcessModel)processModel).getContent());
            setOrderId(((BraintreeLocalPaymentReversedEmailProcessModel)processModel).getOrderId());
            setOrderTotalPrice(((BraintreeLocalPaymentReversedEmailProcessModel)processModel).getOrderTotalPrice());
            setCurrency(processModel.getCurrency().getIsocode());
        }
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getOrderTotalPrice() {
        return orderTotalPrice;
    }

    public void setOrderTotalPrice(String orderTotalPrice) {
        this.orderTotalPrice = orderTotalPrice;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }
}
