/**
 *
 */
package com.braintree.user.converters.populator;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class BrainTreeAddressPopulatorTest {

    @Mock
    private Map<String, Converter<AddressModel, StringBuilder>> addressFormatConverterMap;

    @Mock
    private Converter<AddressModel, StringBuilder> defaultAddressFormatConverter;

    @InjectMocks
    private BrainTreeAddressPopulator unit;

    private static final String BRAINTREE_ADDRESS_ID = "testId";

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void populateShouldSetBraintreeAddressId() {
        AddressModel addressModel = Mockito.mock(AddressModel.class);
        AddressData addressData = Mockito.mock(AddressData.class);
        when(addressModel.getBrainTreeAddressId()).thenReturn(BRAINTREE_ADDRESS_ID);
        when(defaultAddressFormatConverter.convert(any())).thenReturn(new StringBuilder());
        unit.populate(addressModel, addressData);
        verify(addressData).setBrainTreeAddressId(BRAINTREE_ADDRESS_ID);
    }
}
