package com.braintree.facade.backoffice;

import de.hybris.platform.core.model.order.AbstractOrderModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.ordermanagementfacades.payment.data.PaymentTransactionEntryData;

import java.math.BigDecimal;
import java.util.Map;

public interface BraintreeBackofficeAuthorizeFacade {

    boolean isAuthorizePossible(final OrderModel order);

    PaymentTransactionEntryData authorizePayment(final AbstractOrderModel cart, Map<String, String> customFields,
        BigDecimal totalAmount);

    /**
     * This method is used to calculate Total Amount
     * @param cart cart
     * @return total amount
     */
    BigDecimal calculateTotalAmount(final AbstractOrderModel cart);

}
