package com.braintree.converters.populators.impl;

import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.platform.commercefacades.order.converters.populator.CartPopulator;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.servicelayer.dto.converter.Converter;

public class BraintreeExtendedPaymentInfoPopulator extends CartPopulator {

    private Converter<BrainTreePaymentInfoModel, CCPaymentInfoData> brainTreePaymentInfoConverter;

    @Override
    public void populate(final CartModel source, final CartData target) {
        final PaymentInfoModel paymentInfo = source.getPaymentInfo();

        if (paymentInfo instanceof BrainTreePaymentInfoModel) {
            target.setPaymentInfo(brainTreePaymentInfoConverter.convert((BrainTreePaymentInfoModel) paymentInfo));
        }
    }

    public Converter<BrainTreePaymentInfoModel, CCPaymentInfoData> getBrainTreePaymentInfoConverter() {
        return brainTreePaymentInfoConverter;
    }

    public void setBrainTreePaymentInfoConverter(
        Converter<BrainTreePaymentInfoModel, CCPaymentInfoData> brainTreePaymentInfoConverter) {
        this.brainTreePaymentInfoConverter = brainTreePaymentInfoConverter;
    }
}
