/**
 *
 */
package com.braintree.converters.populators.impl;

import static com.braintree.constants.BraintreeConstants.PAY_PAL_EXPRESS_CHECKOUT;
import static com.braintree.constants.BraintreefacadesConstants.PAYPAL_ACCOUNT;
import static com.braintree.enums.BrainTreePaymentMethod.VENMOACCOUNT;

import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import de.hybris.platform.servicelayer.dto.converter.Converter;


public class BrainTreePaymentInfoPopulator implements Populator<BrainTreePaymentInfoModel, CCPaymentInfoData> {

    private Converter<AddressModel, AddressData> addressConverter;
    final String MOCK = "mockValue";

    @Override
    public void populate(final BrainTreePaymentInfoModel source, final CCPaymentInfoData target)
        throws ConversionException {
        target.setId(source.getPk().toString());
        if (source.getPaymentProvider().equals(PAYPAL_ACCOUNT) || source.getPaymentProvider().equalsIgnoreCase(
            PAY_PAL_EXPRESS_CHECKOUT) || source.getPaymentProvider().equals(VENMOACCOUNT.getCode())) {
            target.setCardType(MOCK);
            target.setCardNumber(MOCK);
            target.setExpiryMonth(MOCK);
            target.setExpiryYear(MOCK);

        } else {

            target.setCardNumber(source.getCardNumber());
            target.setExpiryMonth(source.getExpirationMonth());
            target.setExpiryYear(source.getExpirationYear());
            if (source.getCardType() != null) {
                target.setCardType(source.getCardType().toString());
            }
        }
        target.setAccountHolderName(source.getImageSource());
        target.setSubscriptionId(source.getPaymentProvider());
        target.setPaypalFundingSource(source.getPaypalFundingSource());
        target.setSaved(source.isSaved());
        target.setPaymentMethodToken(source.getPaymentMethodToken());
        target.setCardholderName(source.getCardholderName());
        target.setPayer(source.getPayer());
        target.setPaymentMethodNonce(source.getNonce());

        if (source.getBillingAddress() != null) {
            target.setBillingAddress(getAddressConverter().convert(source.getBillingAddress()));
        }
        if(target.getAccountHolderName() == null) {
            target.setAccountHolderName(MOCK);
        }
    }

    /**
     * @return the addressConverter
     */
    public Converter<AddressModel, AddressData> getAddressConverter() {
        return addressConverter;
    }

    /**
     * @param addressConverter
     *           the addressConverter to set
     */
    public void setAddressConverter(final Converter<AddressModel, AddressData> addressConverter) {
        this.addressConverter = addressConverter;
    }

}
