/**
 *
 */
package com.braintree.converters.populators;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.braintree.hybris.data.ws.GooglePayAddressWsDTO;
import com.braintree.paypal.validator.BraintreePayPalAddressDetailValidator;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.user.data.AddressData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class BrainTreeGooglePayAddressPopulatorTest {

    @Mock
    private BraintreePayPalAddressDetailValidator payPalAddressDetailValidator;

    @InjectMocks
    private BrainTreeGooglePayAddressPopulator unit;

    private static final String COUNTY_CODE = "countyCode";
    private static final String ADMINISTRATIVE_AREA = "countyCode";
    private static final String LINE_1 = "line1";
    private static final String LINE_2 = "line2";
    private static final String POSTAL_CODE = "postalCOde";
    private static final String LOCALITY = "Locality";
    private static final String FIRST_NAME = "firstName";
    private static final String PHONE = "phone";

    private GooglePayAddressWsDTO googlePayAddressWsDTO;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        when(payPalAddressDetailValidator.validatePayPalCountryCode(COUNTY_CODE)).thenReturn(true);
        when(payPalAddressDetailValidator.validatePayPalRegionCode(COUNTY_CODE, ADMINISTRATIVE_AREA)).thenReturn(true);

        googlePayAddressWsDTO = Mockito.mock(GooglePayAddressWsDTO.class);
        when(googlePayAddressWsDTO.getCountryCode()).thenReturn(COUNTY_CODE);
        when(googlePayAddressWsDTO.getAdministrativeArea()).thenReturn(ADMINISTRATIVE_AREA);
        when(googlePayAddressWsDTO.getPhoneNumber()).thenReturn(PHONE);
        when(googlePayAddressWsDTO.getAddress1()).thenReturn(LINE_1);
        when(googlePayAddressWsDTO.getAddress2()).thenReturn(LINE_2);
        when(googlePayAddressWsDTO.getPostalCode()).thenReturn(POSTAL_CODE);
        when(googlePayAddressWsDTO.getLocality()).thenReturn(LOCALITY);
        when(googlePayAddressWsDTO.getName()).thenReturn(FIRST_NAME);
    }

    @Test
    public void populateShouldSetRequiredFields() {
        AddressData addressData = new AddressData();
        unit.populate(googlePayAddressWsDTO, addressData);
        verify(payPalAddressDetailValidator).validatePayPalCountryCode(COUNTY_CODE);
        verify(payPalAddressDetailValidator).validatePayPalRegionCode(COUNTY_CODE, ADMINISTRATIVE_AREA);
        Assert.assertEquals(LINE_1, addressData.getLine1());
        Assert.assertEquals(LINE_2, addressData.getLine2());
        Assert.assertEquals(POSTAL_CODE, addressData.getPostalCode());
        Assert.assertEquals(LOCALITY, addressData.getTown());
        Assert.assertEquals(COUNTY_CODE, addressData.getCountry().getIsocode());
        Assert.assertEquals(COUNTY_CODE + "-" + ADMINISTRATIVE_AREA, addressData.getRegion().getIsocode());
        Assert.assertEquals(FIRST_NAME, addressData.getFirstName());
        Assert.assertEquals(PHONE, addressData.getPhone());
    }
}
