/**
 *
 */
package com.braintree.converters.populators;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.braintree.hybris.data.ws.ApplePayAddressWsDTO;
import com.braintree.paypal.validator.BraintreePayPalAddressDetailValidator;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.user.data.AddressData;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class BrainTreeApplePayAddressPopulatorTest {

    @Mock
    private BraintreePayPalAddressDetailValidator payPalAddressDetailValidator;

    @InjectMocks
    private BrainTreeApplePayAddressPopulator unit;

    private static final String COUNTY_CODE = "countyCode";
    private static final String ADMINISTRATIVE_AREA = "countyCode";
    private static final String LINE_1 = "line1";
    private static final String LINE_2 = "line2";
    private static final String POSTAL_CODE = "postalCOde";
    private static final String LOCALITY = "Locality";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";

    private ApplePayAddressWsDTO applePayAddress = Mockito.mock(ApplePayAddressWsDTO.class);

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        when(payPalAddressDetailValidator.validatePayPalCountryCode(COUNTY_CODE)).thenReturn(true);
        when(payPalAddressDetailValidator.validatePayPalRegionCode(COUNTY_CODE, ADMINISTRATIVE_AREA)).thenReturn(true);

        applePayAddress = Mockito.mock(ApplePayAddressWsDTO.class);
        when(applePayAddress.getCountryCode()).thenReturn(COUNTY_CODE);
        when(applePayAddress.getAdministrativeArea()).thenReturn(ADMINISTRATIVE_AREA);
        List<String> addressLines = new ArrayList<>();
        addressLines.add(LINE_1);
        addressLines.add(LINE_2);
        when(applePayAddress.getAddressLines()).thenReturn(addressLines);
        when(applePayAddress.getPostalCode()).thenReturn(POSTAL_CODE);
        when(applePayAddress.getLocality()).thenReturn(LOCALITY);
        when(applePayAddress.getGivenName()).thenReturn(FIRST_NAME);
        when(applePayAddress.getFamilyName()).thenReturn(LAST_NAME);
    }

    @Test
    public void populateShouldSetRequiredFields() {
        AddressData addressData = new AddressData();
        unit.populate(applePayAddress, addressData);
        verify(payPalAddressDetailValidator).validatePayPalCountryCode(COUNTY_CODE);
        verify(payPalAddressDetailValidator).validatePayPalRegionCode(COUNTY_CODE, ADMINISTRATIVE_AREA);
        Assert.assertEquals(LINE_1, addressData.getLine1());
        Assert.assertEquals(LINE_2, addressData.getLine2());
        Assert.assertEquals(POSTAL_CODE, addressData.getPostalCode());
        Assert.assertEquals(LOCALITY, addressData.getTown());
        Assert.assertEquals(COUNTY_CODE, addressData.getCountry().getIsocode());
        Assert.assertEquals(COUNTY_CODE + "-" + ADMINISTRATIVE_AREA, addressData.getRegion().getIsocode());
        Assert.assertEquals(FIRST_NAME, addressData.getFirstName());
        Assert.assertEquals(LAST_NAME, addressData.getLastName());
    }
}
