/*

 */
package com.braintree.setup.impl;

import de.hybris.platform.addonsupport.setup.impl.DefaultAddonSampleDataImportService;
import de.hybris.platform.core.initialization.SystemSetupContext;

/**
 * This class extends DefaultAddonSampleDataImportService and override importContentCatalog method
 */
public class BraintreeSpaSampleDataImportService extends DefaultAddonSampleDataImportService {

    @Override
    protected void importContentCatalog(SystemSetupContext context, String importRoot, String catalogName) {
        if ("electronics".equals(catalogName) || "apparel-uk".equals(catalogName) || "powertools".equals(catalogName)) {
            importImpexFile(context,
                importRoot + "/contentCatalogs/" + catalogName + "ContentCatalog/cms-content.impex", false);
            synchronizeContentCatalog(context, catalogName + "-spa", true);
        }
    }
}
