/**
 *
 */
package com.braintree.filters;

import de.hybris.platform.ycommercewebservices.v2.filter.CartMatchingFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class BraintreeCartMatchingFilter extends CartMatchingFilter {

    private static final String CART_GUID = "cartGuid";

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
            throws ServletException, IOException
    {
        String cartGuid = request.getParameter(CART_GUID);
        if (cartGuid != null)
        {
            getCartLoaderStrategy().loadCart(cartGuid, shouldCartBeRefreshed(request));
        }
        filterChain.doFilter(request, response);
    }
}
