/**
 *
 */
package com.braintree.facade.order.converters.populator;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.order.data.AbstractOrderData;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.core.model.order.AbstractOrderModel;
import de.hybris.platform.core.model.order.payment.CreditCardPaymentInfoModel;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class B2BBrainTreeCartPopulatorTest {

    @Mock
    private Converter<BrainTreePaymentInfoModel, CCPaymentInfoData> brainTreePaymentInfoConverter;

    @Mock
    private Converter<CreditCardPaymentInfoModel, CCPaymentInfoData> creditCardPaymentInfoConverter;

    @InjectMocks
    private B2BBrainTreeCartPopulator unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void addPaymentInformationShouldUseCreditCardConverterIfOrderHaveCreditCardInfoModel() {
        AbstractOrderModel orderModel = Mockito.mock(AbstractOrderModel.class);
        AbstractOrderData result = new AbstractOrderData();
        CreditCardPaymentInfoModel cardPaymentInfoModel = Mockito.mock(CreditCardPaymentInfoModel.class);
        when(orderModel.getPaymentInfo()).thenReturn(cardPaymentInfoModel);

        unit.addPaymentInformation(orderModel, result);
        verify(creditCardPaymentInfoConverter).convert(cardPaymentInfoModel);
    }

    @Test
    public void addPaymentInformationShouldUseBraintreePaymentConverterIfOrderHaveBraintreeInfoModel() {
        AbstractOrderModel orderModel = Mockito.mock(AbstractOrderModel.class);
        AbstractOrderData result = new AbstractOrderData();
        BrainTreePaymentInfoModel cardPaymentInfoModel = Mockito.mock(BrainTreePaymentInfoModel.class);
        when(orderModel.getPaymentInfo()).thenReturn(cardPaymentInfoModel);

        unit.addPaymentInformation(orderModel, result);
        verify(brainTreePaymentInfoConverter).convert(cardPaymentInfoModel);
    }

}
