/**
 *
 */
package com.braintree.facade.impl;

import static com.braintree.constants.BraintreeConstants.BRAINTREE_CREDITCARD_PAYMENT;
import static com.braintree.constants.BraintreeConstants.PAYPAL_PAYMENT;
import static com.braintree.constants.BraintreeConstants.PAY_PAL_EXPRESS_CHECKOUT;

import com.braintree.facade.BrainTreeB2BOrderFacade;
import de.hybris.platform.b2bacceleratorfacades.order.data.ScheduledCartData;
import de.hybris.platform.b2bacceleratorfacades.order.impl.DefaultB2BOrderFacade;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;

public class DefaultBrainTreeB2BOrderFacade extends DefaultB2BOrderFacade implements BrainTreeB2BOrderFacade {

    @Override
    public boolean isCustomerHasActiveReplenishmentForSavedPayPalOrCreditCard() {
        return getReplenishmentHistory().stream()
            .filter(ScheduledCartData::isActive)
            .anyMatch(replenishment -> {
                CCPaymentInfoData paymentInfo = replenishment.getPaymentInfo();
                return PAY_PAL_EXPRESS_CHECKOUT.equalsIgnoreCase(paymentInfo.getSubscriptionId())
                    || PAYPAL_PAYMENT.equalsIgnoreCase(paymentInfo.getSubscriptionId())
                    || BRAINTREE_CREDITCARD_PAYMENT.equalsIgnoreCase(paymentInfo.getSubscriptionId());
            });
    }

}
