package com.braintree.actions;

import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.platform.b2b.process.approval.model.B2BApprovalProcessModel;
import de.hybris.platform.b2bacceleratoraddon.actions.AcceleratorBookingLineEntries;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.task.RetryLaterException;

public class BrainTreeBookingLineEntries extends AcceleratorBookingLineEntries {

    @Override
    public Transition executeAction(final B2BApprovalProcessModel process) throws RetryLaterException {

        final OrderModel order = process.getOrder();
        modelService.refresh(order);

        if (order.getPaymentInfo() instanceof BrainTreePaymentInfoModel) {
            return Transition.OK;
        }
        else {
           return super.executeAction(process);
        }
    }
}
